
/*
*  DISCLAIMER:
*
*      THIS SOFTWARE, SOURCE CODE AND ASSOCIATED MATERIALS INCLUDING BUT NOT LIMITED TO TUTORIALS,
*      GUIDES AND COMMENTARY PROVIDED WITH THIS EXERCISE ARE ONLY DESIGNED FOR REFERENCE PURPOSES
*      TO GIVE AN EXAMPLE TO LICENSEE FOR THEIR OWN NECESSARY DEVELOPMENT OF THEIR OWN SOFTWARE AND/OR
*      APPLICATION. IT IS NOT DESIGNED FOR ANY SPECIAL PURPOSE, SERIAL PRODUCTION OR USE IN MEDICAL,
*      MILITARY, AIR CRAFT, AVIATION, SPACE OF LIFE SUPPORT EQUIPMENT.
*
*      TO THE EXTENT PERMITTED BY LAW, THE EXERCISE SOFTWARE AND/OR SOURCE CODE AND/OR AND ASSOCIATED
*      MATERIALS IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND AND ONLY FOR REFERENCE PURPOSES.
*
*      SYNAPTIC LABORATORIES LTD. MAKES NO WARRANTIES, EITHER EXPRESS OR IMPLIED, WITH RESPECT TO THE
*      LICENSED SOFTWARE AND/OR SOURCE CODE AND/OR ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND
*      DOCUMENTATION PROVIDED HEREUNDER. 
*
*      SYNAPTIC LABORATORIES LTD. SPECIFICALLY DISCLAIMS THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
*      FITNESS FOR A PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT OF ANY INTELLECTUAL
*      PROPERTY RIGHT OF ANY THIRD PARTY WITH REGARD TO THE SOFTWARE, DOCUMENTATION (SCHEMATICS ETC.),
*      SOURCE CODE AND ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND DOCUMENTATION.
*
*      ANY USE, COMPILATION AND TESTING OF THE SOFTWARE AND/OR SOURCE CODE IS AT LICENSEE`S OWN RISK
*      AND LICENSEE IS OBLIGED TO CONDUCT EXTENSIVE TESTS TO AVOID ANY ERRORS AND FAILURE IN THE
*      COMPILED SOURCE CODE, DOCUMENTATION (SCHEMATICS ETC.) AND THE HEREFROM GENERATED SOFTWARE
*      OF LICENSEE.
*
*      EXCEPT FOR WILFULL INTENT SYNAPTIC LABORATORIES LTD. SHALL IN NO EVENT BE ENTITLED TO OR LIABLE
*      FOR ANY INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND OR NATURE, INCLUDING,
*      WITHOUT LIMITATION, BUSINESS INTERRUPTION COSTS, LOSS OF PROFIT OR REVENUE, LOSS OF DATA,
*      PROMOTIONAL OR MANUFACTURING EXPENSES, OVERHEAD, COSTS OR EXPENSES ASSOCIATED WITH WARRANTY
*      OR INTELLECTUAL PROPERTY INFRINGEMENT CLAIMS, INJURY TO REPUTATION OR LOSS OF CUSTOMERS.
*
*/

#include <stddef.h>
#include <stdio.h>
#include <unistd.h>
#include "sys/alt_cache.h"
#include "sys/alt_timestamp.h"
#include "sll_flash_test_003.h"

 int sll_flash_test_003( sll_xspi_flash_dev *fd, uint32_t sdram_base, uint32_t prog_offset, uint32_t span_in_bytes, flash_timing_results *results)
{
  int errors           = 0;
  int erase_errors     = 0;
  uint32_t data_addr_start  = prog_offset;  
  uint32_t data_addr_end    = prog_offset + span_in_bytes;  
  uint32_t data_addr_offset = 0;
  uint32_t data_addr_count  = 0;
  uint32_t data_byte_count  = 0;
  uint32_t flash_reg, status;
  alt_timestamp_type start_time = 0;
  alt_timestamp_type end_time   = 0;

  uint32_t i    = 0;
  uint32_t  cmp_data;
  volatile uint32_t  readback;

  uint32_t *	 flash_32 = (uint32_t *) (fd->data_base);
  uint32_t *	 sdram_32 = (uint32_t*)  (sdram_base);


  if (alt_timestamp_start() != 0)
  {
     lld_printf("Failed to start the timer, make sure the timestamp timer is set");
    return 0;
  }


  lld_printf("Testing  xSPI %s using custom Low Level Driver (DRVR) \r\n", fd->name);
  lld_printf("Through control port of memory controller IP \r\n");

  lld_printf("   R/W MEM            : 0x%08lX \r\n", sdram_base);
  lld_printf("   FLASH              : 0x%08lX \r\n", fd->data_base);
  lld_printf("   Programming offset : 0x%8lX  \r\n", prog_offset);
  lld_printf("   Programming span   : 0x%8lX  \r\n", span_in_bytes);

  //----------------------------------------------------------------------------
  //Flash test
  //----------------------------------------------------------------------------
  lld_printf(" Query Flash...\r\n");
  
  flash_reg = sll_nor_flash_drvr_Poll(fd, 0);
  lld_printf("  Status Register  : %04X \r\n",flash_reg);

  flash_reg = sll_nor_flash_drvr_Poll(fd, 0);
  lld_printf("  Status Register : %04X \r\n",flash_reg);

  //----------------------------------------------------------------------------
  lld_printf(" Query Flash DeviceId ...\r\n");
  //----------------------------------------------------------------------------
  flash_reg = sll_nor_flash_drvr_GetDeviceId(fd);
  lld_printf("  DeviceId   : %04X \r\n",flash_reg);


  //----------------------------------------------------------------------------
  //Flash Program
  //----------------------------------------------------------------------------
  lld_printf("Erase Flash : Sector Size %d K...\r\n", (fd->sector_size/1024));

  //----------------------------------------------------------------------------
  //Erase Sector
  //----------------------------------------------------------------------------
  if (!errors){
    start_time = alt_timestamp();
 	 lld_printf("   Erase Start\r\n");
   
    data_addr_offset = data_addr_start;
    
    //Erase Sectors according to  data offset Size   
    
    while (data_addr_offset < data_addr_end) {
	     status = sll_nor_flash_drvr_SectorEraseOp( fd, data_addr_offset);
       
	     if (status != NOR_DEV_IS_IDLE) {
		     lld_printf("    Erase FAIL : Sector(%d K) %d  with error status 0x%04x  \r\n", (fd->sector_size/1024), (data_addr_offset/fd->sector_size), status);
		     errors += 1;
	     }
	     data_addr_offset +=  fd->sector_size;
	  }
    end_time = alt_timestamp();

  }


  if (!errors){
  	 lld_printf("    Erase Pass\r\n");
     results->flash_erase_time = (unsigned long)((((double)1000) * ((double)(end_time - start_time))) / ((double)alt_timestamp_freq())) ;

     lld_printf("Flash erase time %d \r\n", results->flash_erase_time);

  } else {
  	 lld_printf("    Erase Fail\r\n");
     results->flash_erase_time = 0; 	
  }

  //----------------------------------------------------------------------------
  //Verify Erase data
  //----------------------------------------------------------------------------
  if (!errors){
   
	  lld_printf("Erase Verify \r\n ");
    data_addr_offset = data_addr_start;
    
    //Erase Sectors according to  data offset Size   
    //Each Sector is 4 Kb
    start_time = alt_timestamp();
    
     erase_errors = 0;

       
 	   for (i=0; i< (span_in_bytes/4); i++) {
       readback = flash_32[(data_addr_offset/4)+i];
     
       if (readback != 0xFFFFFFFF) {
 	        lld_printf("    Erase Verify FAIL - @addr : 0x%08lX  : Data should be 0xffffffff but was 0x%08lX \r\n", data_addr_offset+(i*4), readback);
 	        erase_errors += 1;
 	        break;
       }
     }  
     
	  
    end_time = alt_timestamp();

  }

  if (!errors){
  	 lld_printf("    Erase Verify Pass\r\n");
     results->flash_erase_verify_time = (unsigned long)((((double)1000) * ((double)(end_time - start_time))) / ((double)alt_timestamp_freq())) ;
  } else {
  	 lld_printf("    Erase Verify Fail\r\n");
     results->flash_erase_verify_time = 0; 	
  }

  //----------------------------------------------------------------------------
  //fill part of PSRAM, so it can then copy it
  //----------------------------------------------------------------------------
  if (!errors){
	  lld_printf("PSRAM fill with data\r\n ");

	  for (i=0; i< (span_in_bytes/4); i++) {
		  sdram_32[i] = (data_addr_start/4) + i;// initial_seed + i + ((i+1)<<16);
	  }
  }


  //----------------------------------------------------------------------------
  //Programming start
  //----------------------------------------------------------------------------
  if (!errors){
	  lld_printf("Program Start  \r\n ");
    start_time = alt_timestamp();

    data_addr_offset = data_addr_start;
    data_addr_count  = span_in_bytes;
    sdram_32 = (uint32_t*)  (sdram_base);

    while (data_addr_offset  <  data_addr_end ) {      

      //check program span
      if (data_addr_count > fd->sector_size) {
        data_byte_count  = fd->sector_size;
      } else {
        data_byte_count  = data_addr_count;
      }
      
      status   = sll_nor_flash_drvr_memcpy (fd, data_addr_offset, data_byte_count, sdram_32);

      if (status != NOR_DEV_IS_IDLE) {
		     lld_printf("    Program FAIL : Sector %d  with error status 0x%04x  \r\n", (data_addr_offset/fd->sector_size), status);
		     errors += 1;
	     } 
	     
	     data_addr_offset +=   data_byte_count;
	     data_addr_count  -=   data_byte_count;
	     sdram_32         +=  (data_byte_count/4); 
   	}
    end_time = alt_timestamp();

  }

  if (!errors){
  	 lld_printf("    Program Pass\r\n");
     results->flash_program_time = (unsigned long)((((double)1000) * ((double)(end_time - start_time))) / ((double)alt_timestamp_freq())) ;
  } else {
  	 lld_printf("    Program Fail\r\n");
     results->flash_program_time = 0; 	
  }
  //----------------------------------------------------------------------------
  //Compare data
  //----------------------------------------------------------------------------
  if (!errors){
	  lld_printf("Verify  Data Written to Flash \r\n");
    start_time = alt_timestamp();
	  sdram_32   = (uint32_t*)  (sdram_base);

	  for (i=0; i< (span_in_bytes/4); i++) {
      readback = flash_32[(data_addr_start/4)+i];
		  cmp_data = sdram_32[i];

		  if (cmp_data != readback) {
			  lld_printf("    Verify Data FAIL - @addr : 0x%08lX  : Data should be 0x%08lX but was 0x%08lX \r\n", (data_addr_start + i*4), cmp_data, readback);
			  errors += 1;
			  break;
		  }
	  }
    end_time = alt_timestamp();
  }

  if (!errors){
  	 lld_printf("    Program Verify Pass\r\n");
     results->flash_program_verify_time = (unsigned long)((((double)1000) * ((double)(end_time - start_time))) / ((double)alt_timestamp_freq())) ;
  } else {
  	 lld_printf("    Program Verify Fail\r\n");
     results->flash_program_verify_time = 0; 	
  }


  if (errors) {
    lld_printf("TEST FAIL - Flash Programming with %d errors\r\n", errors);
  } else {
    lld_printf("TEST PASS - Flash Programming done\r\n");
  }

  return errors;
}



/*
 * Typically:
 *
 */
 
